#include "SCI_Boot.h"
#include "Flash281x_API_Library.h"
#include "Example_Flash281x_API.h"

extern void main2(void);
Uint16 Example_CsmUnlock(void);
void SCI_SendStatus(char *);
extern void Example_Error(Uint16);
extern void MemCopy(Uint16 *, Uint16 *, Uint16 *);

extern volatile struct SCI_REGS SCIARegs;

// These are defined by the linker 
extern Uint16 textLoadStart;
extern Uint16 textLoadEnd;
extern Uint16 textRunStart;
extern Uint16 econstLoadStart;
extern Uint16 econstLoadEnd;
extern Uint16 econstRunStart;

//The CKFA's entry point code is main() and is transferred by Boot-ROM code 
//to unsecured RAM.  From there it attempts to unlock the CSM.
void main(void)
{

   	Uint16 Status;

	//Clear HyperTerminal screen
	SCIARegs.SCIFFTX.bit.SCIFFENA = 1;
	SCIARegs.SCIFFTX.bit.TXFIFOXRESET = 0;
	SCIARegs.SCIFFTX.bit.TXFIFOXRESET = 1;
	SCI_SendStatus("\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\r");
	SCI_SendStatus("\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\r");

	//Attempt CSM unlock
	Status = Example_CsmUnlock();
	if(Status != STATUS_SUCCESS) 
	{
		SCI_SendStatus("Incorrect passwords, failed to unlock processor.\n\r");
	    asm("    ESTOP0");
	    asm("    SB 0, UNC");
	}
	SCI_SendStatus("Processor is unlocked.\n\r");

	//Copy main2() and the rest of the CKFA code to secured RAM to
	//make room for the application code transfer to RAM. 
	MemCopy(&textLoadStart, &textLoadEnd, &textRunStart);
	MemCopy(&econstLoadStart, &econstLoadEnd, &econstRunStart);
	main2();

}

//#################################################
// void SCI_SendStatus(void)
//-----------------------------------------------------
// This routine sends a series of characters via SCIA
// 
//-----------------------------------------------------

//This function needs to be in this file since the linker associates code
//from this file to have a load address in unsecured RAM
void SCI_SendStatus(char *msg)
{
	while(*msg)
	{
		while((SCIARegs.SCIFFTX.bit.TXFFST<16) && *msg) 
			SCIARegs.SCITXBUF = *msg++;

		while(SCIARegs.SCIFFTX.bit.TXFFST) ;	//TX FIFO empty?
	}

    return;   
}

/*------------------------------------------------------------------
   Example_CsmUnlock

   Unlock the code security module (CSM)
 
   Parameters:
  
   Return Value:
 
            STATUS_SUCCESS         CSM is unlocked
            STATUS_FAIL_UNLOCK     CSM did not unlock
        
   Notes:
     
-----------------------------------------------------------------*/
Uint16 Example_CsmUnlock()
{
    volatile Uint16 temp;
    
    // Load the key registers with the current password
    // These are defined in Example_Flash281x_CsmKeys.asm
    
    EALLOW;
    *KEY0 = PRG_key0;
    *KEY1 = PRG_key1;
    *KEY2 = PRG_key2;
    *KEY3 = PRG_key3;
    *KEY4 = PRG_key4;
    *KEY5 = PRG_key5;
    *KEY6 = PRG_key6;
    *KEY7 = PRG_key7;   
    EDIS;

    // Perform a dummy read of the password locations
    // if they match the key values, the CSM will unlock 
        
    temp = *PWL0;
    temp = *PWL1;
    temp = *PWL2;
    temp = *PWL3;
    temp = *PWL4;
    temp = *PWL5;
    temp = *PWL6;
    temp = *PWL7;
 
    // If the CSM unlocked, return succes, otherwise return
    // failure.
    if ( (*CSMSCR & 0x0001) == 0) return STATUS_SUCCESS;
    else return STATUS_FAIL_CSM_LOCKED;
    
}


